// UserCluster.java
// Version 0.4 
// Last Updated: 10/16/2000

// Change Log
// RP101600 - Standardize naming, tab spacing, and commenting.
// Used by ClusterManager

package Alkindi.Services.InternalData;

import Alkindi.Data.*;
import java.util.*;
import Alkindi.Services.AlkExcept;

/* 
$Header: UserCluster.java, 16, 4/26/01 2:36:59 PM, Schwartz, Joe$
$Log: 
 16   Alkindi Development1.15        4/26/01 2:36:59 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 15   Alkindi Development1.14        4/26/01 1:46:07 PM   Schwartz, Joe   Moved
      to new package.
 14   Alkindi Development1.13        3/16/01 12:30:07 PM  Schwartz, Joe   Fixed
      error in recalcVMeans where products with no ratings were assigned NaN
      (0/0).
 13   Alkindi Development1.12        2/13/01 5:54:45 PM   Schwartz, Joe  
      Changed to account for new SparseRatingsArray class, used for base class
      of RatingSpacePoint.
 12   Alkindi Development1.11        1/26/01 5:48:30 PM   Schwartz, Joe  
      Improving efficiency.
 11   Alkindi Development1.10        12/28/00 1:07:28 PM  Schwartz, Joe   Added
      Version Control header info.
 10   Alkindi Development1.9         12/26/00 6:57:17 PM  Schwartz, Joe   
 9    Alkindi Development1.8         12/18/00 12:06:25 PM Schwartz, Joe   Moved
      from (public) BusinessDataTypes package.
 8    Alkindi Development1.7         12/15/00 6:18:18 PM  Schwartz, Joe  
      Chagned to reflect modifications in UserRatings.
 7    Alkindi Development1.6         12/5/00 1:21:19 PM   Schwartz, Joe   
 6    Alkindi Development1.5         12/3/00 5:28:01 PM   Schwartz, Joe   
 5    Alkindi Development1.4         12/2/00 2:57:24 PM   Schwartz, Joe   
 4    Alkindi Development1.3         12/2/00 1:02:13 PM   Schwartz, Joe   
 3    Alkindi Development1.2         10/22/00 10:38:47 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 2    Alkindi Development1.1         10/17/00 2:16:35 PM  Schwartz, Joe  
      Delivery 10.16.00
 1    Alkindi Development1.0         10/7/00 4:26:03 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Represents data for a UserCluster. This class is used during the clustering process to hold the VMeans and UserRatings objects associated with a UserCluster.
 */
public class UserCluster implements Cloneable 
{
	public UserRatingsList userRatingsList = null;
	public VMeans vMeans = null;
	private static final UserCluster ucInstance = new UserCluster();
	
	/**
	 * @roseuid 3A36896A02AF
	 */
	public final java.lang.String dump() 
	{
		String str = "UserCluster membership:\n";
		Iterator userIt = userRatingsList.userIterator();
		while (userIt.hasNext()) {
			SystemUser su = (SystemUser)userIt.next();
			str += " user " + su.id + "\n";
		}
		str += "	cluster Total: " + userRatingsList.numUsers() + " users.\n\n";
		
		return str;
	}
	
	/**
	 * @roseuid 3A6F326C0138
	 */
	public static final UserCluster getInstance(final VMeans vm, final ProductList products) 
	{
		try {
			UserCluster newUC = (UserCluster)ucInstance.clone();
			//newUC.vMeans = (VMeans)vm.clone();
			newUC.vMeans = new VMeans();
			newUC.userRatingsList = new UserRatingsList();
			newUC.userRatingsList.products = products;
			return newUC;
		}
		catch (CloneNotSupportedException cne) {
			return null;
		}
	}
	
	/**
	 * @roseuid 3A291F5E02BF
	 */
	public final int numUsers() 
	{
		return userRatingsList.numUsers();
	}
	
	/**
	 * @roseuid 3A719DFD01E4
	 */
	public final void recalcVMeans() throws AlkExcept 
	{
		if (numUsers() < 1)
			return;
//		return ;
		//vMeans = new VMeans();
		
		Iterator pdIt = userRatingsList.products.iterator();
		while (pdIt.hasNext()) {
			float aveEval = 0;
			int usersWhoRated = 0;
			
			Product pd = (Product)pdIt.next();
			Iterator urIt = userRatingsList.userRatingsIterator();
			while (urIt.hasNext()) {
				UserRatings ur = (UserRatings)urIt.next();
				float eval = ur.getEval(pd.id);
				if (eval > 0) {
					aveEval += eval;
					usersWhoRated ++;
				}
			}
			if (usersWhoRated > 0)
				aveEval /= usersWhoRated;
			vMeans.putEval(pd.id, aveEval);
		}
			

/*
		QuickProdStatsList qpl = QuickProdStatsList.getInstance();
		Iterator urIt = userRatingsList.userRatingsIterator();
		while (urIt.hasNext()) {
			UserRatings ur = (UserRatings)urIt.next();
			Iterator enIt = ur.entryIterator();
			while (enIt.hasNext()) {
				Map.Entry en = (Map.Entry)enIt.next();
				Product pd = (Product)en.getKey();
				Float eval = (Float)en.getValue();
				if (eval != null) {
					QuickProdStats qps = qpl.get(pd);
					if (qps == null) {
						qps = QuickProdStats.getInstance();
						qpl.add(pd, qps);
					}
					qps.addEval(eval.floatValue());
				}
			}	//	END while (more evals for user)
		}	//	END while (more user ratings)
		//vMeans.clear();
		vMeans = new VMeans();
		try {
			Iterator prodIt = userRatingsList.products.iterator();
			int prodIdx = 0;
			while (prodIt.hasNext()) {
				Product pd = (Product)prodIt.next();
				QuickProdStats aStat = qpl.get(pd);
				if (aStat == null)  {
					vMeans.addEval(pd, new Float(0D));
				}
				else {
					vMeans.addEval(pd, new Float(aStat.getAvgEval()));
				}
				prodIdx ++;
			} 
		}
		catch(Exception e) {
			e.printStackTrace();
			throw new AlkExcept("Error in retrieving eavluation averages.", 2102);
		}*/
	}
}
